'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function LOAD_IMAGES(list) {
    return Promise.all(list.map(function (v) {
        return LOAD_IMAGE(v);
    }));
}

function LOAD_IMAGE(item) {
    return new Promise(function (resolve, reject) {
        var url = item.bg_data && item.bg_data.bg;
        if (url) {
            var img = new Image();
            img.addEventListener('load', function () {
                resolve();
            });
            img.src = url;
            item.background = img;
        } else {
            resolve();
        }
    });
}

var ANIMATE = function () {
    function ANIMATE(global, article, keyWords, fn) {
        var _this = this;

        _classCallCheck(this, ANIMATE);

        this.global = global;
        this.article = article;
        this.keyWords = keyWords;
        this.list = [];
        this.article_scene = {};
        this.article_audio = {};
        this.article_color = {};
        this.global_scene = null;
        this.global_audio = null;
        this.global_color = null;
        this.active_bgm = null;
        this.active_bg = null;
        this.styleBox = null;
        this.splitWord = '||';

        this.background_switch = null; //正在背景切换的promise对象

        // let times = 0;
        // for (let i in this.keyWords) {
        //     let item = this.keyWords[i];
        //     item.effect.id = 1000;
        //     item.effect.times = times++;
        // }

        this.animate_list = []; //动画列表
        this.animate_obj = null; //动画组件


        this.getPreload();
        this.type = null;
        this.isPlaying = false;
        this.active = null;
        this.toReg();
        // $(function () {
            /*添加改变字体的style节点*/
            var style = document.createElement('style');
            this.styleBox = style;
            $('head').append(style);
            
            _this.loadScript().then(function () {
                _this.preLoad(function () {
                    fn();
                    _this.init();
                });
            });
        // });
    }

    _createClass(ANIMATE, [{
        key: 'init',
        value: function init() {


            //关闭夜间模式切换功能
            $('#dark').off();

            //关闭阅读模式切换
            $('.menu-loadMode li').off();
        }
    }, {
        key: 'getPreload',
        value: function getPreload() {
            var list = this.list,
                keywords = this.keyWords,
                global = this.global,
                article = this.article;
            /*全局场景*/
            if (global) {
                /*场景背景和字体颜色*/
                if (global.bg) {
                    var item = {
                        bg_data: global.bg,
                        scene: global.scene
                    };
                    list.push(item);
                    this.global_scene = item;
                }
                /*场景背景音效*/
                var audio_src = global.audio && global.audio.url;
                if (audio_src) {
                    var audio = document.createElement('audio');
                    audio.src = audio_src;
                    this.global_audio = audio;
                }
                this.global_color = global.color.value;
            }

            /*段落场景*/
            for (var key in article) {
                var _item = article[key];

                if (_item) {
                    var state = false,
                        scene = {
                        id: key,
                        bg_data: null,
                        scene: null
                    };

                    if (_item.bg && _item.bg.id) {
                        scene.bg_data = _item.bg;
                        state = true;
                    }
                    if (_item.audio && _item.audio.id) {
                        scene.scene = _item.scene;
                        state = true;
                    }
                    /*场景  场景特效*/
                    // let scene = {
                    //     id: key,
                    //     bg_data: item.bg,
                    //     scene: item.scene
                    // };
                    if (state) {
                        list.push(scene);
                        this.article_scene[key] = scene;
                    }
                }

                var _audio_src = _item && _item.audio && _item.audio.url;
                if (_audio_src) {
                    /*场景背景音效*/
                    var _audio = document.createElement('audio');
                    _audio.src = _audio_src;
                    this.article_audio[key] = _audio;
                }
                var color = _item.color.value;
                if (color) {
                    this.article_color[key] = color;
                }
            }

            /*关键字*/
            for (var k in keywords) {
                var kw = keywords[k];
                if (kw.effect && kw.effect.id) {
                    this.animate_list.push(kw.effect.id); //等待预加载
                }
                if (kw.audio && kw.audio.id) {
                    var _audio2 = document.createElement('audio');
                    _audio2.src = kw.audio.url;
                    kw.audio.audio = _audio2;
                }
            }
        }
    }, {
        key: 'toReg',
        value: function toReg() {
            var kw = this.keyWords,
                arr = [];
            for (var i in kw) {
                arr.push('(' + i + ')');
            }
            this.reg = new RegExp(arr.join('|'), 'ig');

            // for (let k in obj) {
            //     let item = obj[k];
            //     arr = [...arr, ...item];
            //     obj[k] = {
            //         name: k,
            //         key_words: item,
            //         reg: new RegExp(item.join('|'), 'i')//后面才用test方法验证  不能加g属性 影响lastIndex
            //     }
            // }
            // this.reg = new RegExp(arr.join('|'), 'ig');
        }
    }, {
        key: 'match',
        value: function match(content) {
            // let result = content.match(this.reg);
            return content.match(this.reg);
            // if (result) {
            //     let params = this.params;
            //     for (let i in params) {
            //         let v = params[i];
            //         if (v.reg.test(content)) {
            //             keys.push(v.name);
            //         }
            //     }
            //     return {
            //         keys,
            //         result
            //     };
            // } else {
            //     return null
            // }
        }
    }, {
        key: 'scan',
        value: function scan(dom1, dom2) {
            var content = dom1.innerText;
            var keys = this.match(content);
            if (keys) {
                var arr = [];
                /*去重*/
                for (var k in keys) {
                    var item = keys[k];
                    if (arr.indexOf(item) < 0) {
                        arr.push(item);
                    }
                }
                dom1.setAttribute('data-keywords', arr.join(this.splitWord));
                dom2.setAttribute('data-keywords', arr.join(this.splitWord));
                // this.push(dom1, dom2, keys, id);
            }
        }
    }, {
        key: 'getInfo',
        value: function getInfo() {
            var arr = [];
            this.list.forEach(function (v, i) {
                var node = read.loadMethod == 0 ? v.node[0] : v.node[1];
                var top = $(node).offset().top;
                if (top != 0) {
                    v.top = top;
                    v.index = i;
                    arr.push(v);
                }
            });
            return arr;
        }
    }, {
        key: 'trigger',
        value: function trigger(kw) {
            var _this2 = this;

            var keywords = kw.split(this.splitWord),
                _keywords = this.keyWords,
                animate = null;
            keywords.forEach(function (k) {
                var item = _keywords[k];
                if (item) {
                    if (item.audio.audio) {
                        // item.audio.audio.play();
                        new AUDIO(item.audio.audio, 0);
                    }
                    if (item.effect.id && _this2.animate_obj) {
                        animate = item;
                    }
                }
            });

            /*限制一段只有一个动效*/
            if (animate) {
                var bg_switch = this.background_switch;
                if (bg_switch) {
                    bg_switch.then(function () {
                        _this2.animate_obj.play(animate.effect.id, animate.effect.times).then(function () {
                            _this2.active_bg && _this2.scene.background(_this2.active_bg);
                        });
                    });
                } else {
                    this.animate_obj.play(animate.effect.id, animate.effect.times).then(function () {
                        _this2.active_bg && _this2.scene.background(_this2.active_bg);
                    });
                }
            }
        }
    }, {
        key: 'done',
        value: function done() {
            this.isPlaying = false;
        }
    }, {
        key: 'background',
        value: function background(id) {
            var _this3 = this;

            var scene = id ? this.article_scene[id] : null,
                audio = this.article_audio[id],
                color = this.article_color[id] || this.global_color;
            if (scene) {
                var pms = null;
                if (scene.background) {
                    pms = this.scene.background(scene.background);
                } else if (this.global_scene && this.global_scene.background) {
                    pms = this.scene.background(this.global_scene.background);
                } else {
                    pms = Promise.resolve();
                }
                this.background_switch = pms;
                pms.then(function () {
                    _this3.active_bg = scene.background;
                    _this3.background_switch = null;
                    _this3.backgroundAudio(audio);
                });
            } else if (this.global_scene) {
                var _pms = null;
                if (this.global_scene.background) {
                    _pms = this.scene.background(this.global_scene.background);
                } else {
                    _pms = Promise.resolve();
                    this.scene.clear();
                }
                this.background_switch = _pms;
                _pms.then(function () {
                    _this3.active_bg = _this3.global_scene.background;
                    _this3.background_switch = null;
                    _this3.backgroundAudio(audio);
                });
            } else {
                this.scene.clear();
                this.active_bgm && this.active_bgm.stop();
                // this.backgroundAudio(audio);
            }
            if (color) {
                /*标题和作者名字*/
                $('#title').css({
                    color: color
                });
                $('.r-author-name a').css({
                    color: color
                });
                this.styleBox.innerHTML = '.read-text{color:' + color + ' !important}';
            } else {
                this.styleBox.innerHTML = '';
            }
        }
    }, {
        key: 'backgroundAudio',
        value: function backgroundAudio(audio) {

            audio = audio || this.global_audio || null;
            if (audio) {
                if (this.active_bgm) {
                    if (this.active_bgm.audio.src != audio.src) {
                        this.active_bgm.stop();
                        this.active_bgm = new AUDIO(audio, 1);
                    }
                } else {
                    this.active_bgm = new AUDIO(audio, 1);
                }
            } else {
                this.active_bgm && this.active_bgm.stop();
                this.active_bgm = null;
            }
        }
    }, {
        key: 'preLoad',
        value: function preLoad(fn) {
            var _this4 = this;

            var list = this.list;
            LOAD_IMAGES(list).then(function () {
                _this4.scene = new SCENE();
                _this4.animate_obj = new E_ANIMATE(_this4.scene.canvas);
                var animate_list = _this4.animate_list;
                Promise.all(animate_list.map(function (v) {
                    _this4.animate_obj.preLoad(v);
                })).then(function () {
                    fn && fn();
                });
            });
        }
    }, {
        key: 'loadScript',
        value: function loadScript() {
            var _this5 = this;

            var list = ['./Public/js/tweenmax/easing/EasePack.min.js', './Public/js/tweenmax/TweenMax.min.js', './Public/js/read/scene.js'];
            return Promise.all(list.map(function (src) {
                return _this5.createScript(src);
            }));
        }
    }, {
        key: 'createScript',
        value: function createScript(src) {
            var s = document.createElement('script');

            return new Promise(function (resolve, reject) {
                s.addEventListener('load', function () {
                    $(s).remove();
                    resolve();
                });
                $('head').append(s);
                s.src = src;
            });
        }
    }]);

    return ANIMATE;
}();

var AUDIO = function () {
    /**
     *
     * @param audio
     * @param type 0：普通音效 1:背景循环
     */
    function AUDIO(audio, type) {
        _classCallCheck(this, AUDIO);

        if (!audio) return;
        this.audio = audio;
        this.type = type;
        this.status = true;
        this.init();
        this.play();
    }

    _createClass(AUDIO, [{
        key: 'init',
        value: function init() {
            var _this6 = this;

            var audio = this.audio;
            $(document).one('touchstart.audio', function () {
                _this6.status && _this6.play();
                _this6.status = false;
            });
            $(document).one('touchmove.audio', function () {
                _this6.status && _this6.play();
                _this6.status = false;
            });
            $(document).one('touchend.audio', function () {
                _this6.status && _this6.play();
                _this6.status = false;
            });
            $(audio).on('ended', function () {
                _this6.type == 1 && _this6.play();
            });
        }
    }, {
        key: 'play',
        value: function play() {
            this.audio && this.audio.play();
        }
    }, {
        key: 'stop',
        value: function stop() {
            var audio = this.audio;
            this.status = false;
            if (audio) {
                audio.pause();
            }
        }
    }]);

    return AUDIO;
}();